//
//  Key.h
//  Keychain
//
//  Created by Wade Tregaskis on Fri Jan 24 2003.
//  Copyright (c) 2003 Wade Tregaskis. All rights reserved.
//

#import "NSCachedObject.h"
#import <Foundation/Foundation.h>
#import <Security/Security.h>
#import "CSSMUtils.h"


@interface Key : NSCachedObject {
    SecKeyRef key;
    const CSSM_KEY *CSSMKey;
    int error;
}

+ (Key*)keyWithKeyRef:(SecKeyRef)ke;
+ (Key*)keyWithCSSMKey:(const CSSM_KEY *)ke;

- (Key*)initWithKeyRef:(SecKeyRef)ke;
- (Key*)initWithCSSMKey:(const CSSM_KEY *)ke;

- (CSSM_HEADERVERSION)version;

- (CSSM_KEYBLOB_TYPE)blobType;
- (NSString*)nameOfBlobType;

- (CSSM_KEYBLOB_FORMAT)format;
- (NSString*)nameOfFormat;

- (CSSM_ALGORITHMS)algorithm;
- (NSString*)nameOfAlgorithm;

- (CSSM_ALGORITHMS)wrapAlgorithm;
- (NSString*)nameOfWrapAlgorithm;

- (CSSM_KEYCLASS)keyClass;
- (NSString*)nameOfClass;

- (int)logicalSize;

- (CSSM_KEYATTR_FLAGS)attributes;
- (CSSM_KEYUSE)usage;

- (NSCalendarDate*)startDate;
- (NSCalendarDate*)endDate;

- (CSSM_ENCRYPT_MODE)wrapMode;
- (NSString*)nameOfWrapMode;

- (NSString*)description;

- (int)lastError;

- (const CSSM_KEY *)CSSMKey;
- (SecKeyRef)keyRef;

@end
